#include "ConstantBuffers.hlsli"
#include "RayMarchingUtils.hlsli"
//Raymarching Distance Fields
//About http://www.iquilezles.org/www/articles/raymarchingdf/raymarchingdf.htm
//Also known as Sphere Tracing


static const int   MAX_TRACE_STEPS = 128;
static const float STEPS_INC = 1.0f / MAX_TRACE_STEPS;
static const float TRACE_HIT_THRESHOLD = 0.01;
static const float glowFallOff = 0.1;
static const float4 BACKGROUND_COLOR = float4(0.1,0.1,0.1,1);
static const int    LedCubeSide = 16;
static const int    LedCubeSideMinusOne =  LedCubeSide -1.;
static const int    LedCount = LedCubeSide * LedCubeSide * LedCubeSide;
static const int    LedCountMinusOne = LedCount -1;
static const float  HalfLedCubeSide = 0.5*LedCubeSide;
static const float3 LedOffset = (float3).5;
static const float eps = 0.0001;
static const float Pi = 3.1415926;
static int sceneIndex = 0;

float test(in float3 warped, in float3 boxSize)
{
    const float cornerRAdius = 0.002;
    //const float d = 1e10; 
   // d = _union(d,);
    float d = _union(udRoundBox(warped, boxSize  , cornerRAdius ),udRoundBox(warped, boxSize.yzx  , cornerRAdius ));
    d = _union(d,udRoundBox(warped, boxSize.zxy  , cornerRAdius ));

    return d;
}

float sceneLed(in float3 p, in float intensity)
{
    //float d = 1e10;
    //float scaleBis = 10.;
    //float3 warped =  (p* scaleBis) % (scaleBis)  - .5 * scaleBis;
    //float scale = 0.2 - .19*smoothstep(-0.1, 1., -intensity); 
    //d = sdSphere(warped , scale * scaleBis) / scaleBis;// * scaleBis;
   
    //p -=0.5;
    float3 warped = p  -0.5 - floor(p ); //abs(p - floor(p))-0.5;//p  -0.5 - floor(p );// frac(p)-0.5;// p  %1. -.5;
    float scale = 0.2 - 0.19*smoothstep(-0.1, 1., -intensity); // 0.01 et 0.2
   // float3 boxSize = float3(0.33, 0.33, 1.) * scale;
    float3 boxSize = float3(0.125, 0.125, .5) * scale;
   
    float d = test(warped, boxSize);
    const float cornerRAdius = 0.002;
    //float offset = 0.5;
    //float3x3 axis = float3x3(WorldAxis.X, WorldAxis.Y, WorldAxis.Z);
    //float2 offsets = float2(-1,1);
    //for (int i=0; i<3; i++)
    //{
    //   /* for (int j=0; j<2; j++)
    //    {
    //        float3 warpedBis = warped + offsets[j]* axis[i];
    //        d = _union(d,test(warped, boxSize));
    //    }*/
    //    float3 wapedBis = warped - offset*axis[i];

    //    d = _union(d,udRoundBox(wapedBis, boxSize  , cornerRAdius ));
    //    d = _union(d,udRoundBox(wapedBis, boxSize.yzx  , cornerRAdius ));
    //    d = _union(d,udRoundBox(wapedBis, boxSize.zxy  , cornerRAdius ));

    //    wapedBis = warped + offset*axis[i];

    //     d = _union(d,udRoundBox(wapedBis, boxSize  , cornerRAdius ));
    //    d = _union(d,udRoundBox(wapedBis, boxSize.yzx  , cornerRAdius ));
    //    d = _union(d,udRoundBox(wapedBis, boxSize.zxy  , cornerRAdius ));
    //}


    //
    return d;
}

float sceneCube(in float3 p)
{
    float d = 1e10;
    d=  _union(d,udRoundBox(p-HalfLedCubeSide, HalfLedCubeSide, 0.00));
    d+=  TRACE_HIT_THRESHOLD;
    return d;
}




// ambient occlusion approximation
float ambientOcclusion(float3 p, float3 n, float intensity)
{
    const int steps = 3;
    const float delta = 0.5;

    float a = 0.0;
    float weight = 1.0;
    for(int i=1; i<=steps; i++)
    {
        float d = (float(i) / float(steps)) * delta; 
        a += weight*(d - sceneLed(p + n*d, intensity));
        weight *= 0.5;
    }
    return clamp(1.0 - a, 0.0, 1.0);
}

//float ambientOcclusion(float3 p, float3 n) {
//	float i = 3;
//    const float d = 0.5;
//    float o;
//    float intensity = intensityAt(p);
//	for (o=1.;i>0.;i--) 
//    {
//        float3 spos = (p+n*i*d);
//		o-=(i*d-abs(sceneLed(spos, intensity)))/pow(2.,i);
//	}
//	return o;
//}

// calculate scene normal
//float3 sceneNormal( in float3 pos )
//{
//    const float eps = 0.001;
//    float3 n;
//    float intensity = intensityAt(pos);
//    n.x = sceneLed( float3(pos.x+eps, pos.y, pos.z), intensity ) - sceneLed( float3(pos.x-eps, pos.y, pos.z), intensity );
//    n.y = sceneLed( float3(pos.x, pos.y+eps, pos.z), intensity ) - sceneLed( float3(pos.x, pos.y-eps, pos.z), intensity );
//    n.z = sceneLed( float3(pos.x, pos.y, pos.z+eps), intensity ) - sceneLed( float3(pos.x, pos.y, pos.z-eps), intensity );
//    return normalize(n);
//}

//Normals the tetrahedral way, see http://www.pouet.net/topic.php?which=5604
float3 sceneNormal(float3 p, in float intensity) {
	const float2 e = float2(eps, -eps);
	float4 o = float4(sceneLed(p+e.xyy, intensity), sceneLed(p+e.yyx, intensity), sceneLed(p+e.yxy, intensity), sceneLed(p+e.xxx, intensity));
	return (o.wzy+o.xww-o.zxz-o.yyx)/(4.*e.x);
}
float cubicPulse( float c, float w, float x )
{
    x = abs(x - c);
    if( x>w ) return 0.0f;
    x /= w;
    return 1.0f - x*x*(3.0f-2.0f*x);
}
// trace ray using sphere tracing
float3 trace(in IntensityProvider scene, in LedDomain domain, float3 ro, float3 rd, out bool hit, out int nbSteps, out float glowFactor, out float intensity)
{
    hit = false;
    float3 pos = ro;
    float3 hitPos = ro;
    float l = 0.;
    glowFactor = 0;
    float normalizedStep =0.;
    bool bIsLedOn = false;
    for(nbSteps=0; nbSteps < MAX_TRACE_STEPS; nbSteps++)
    {
        bIsLedOn = false;
    
        float d = 1e10;

        if(domain.IsOutside(pos))
        {
            intensity = 0;
            d = sceneCube(pos);
        }
        else
        {
           intensity = scene.IntensityAt(pos);
           d = sceneLed(pos,intensity);  

            if(intensity > 0.)
            {
                l = abs(d);
                normalizedStep = (nbSteps+1)*STEPS_INC;            
                glowFactor += intensity*cubicPulse(0.,0.5,l)*normalizedStep * normalizedStep;//smoothstep(0.,glowFallOff,l) * (1 - smoothstep(glowFallOff+glowPeak,2*glowFallOff+glowPeak,l) ) * normalizedStep *normalizedStep; 
            }
        }

        if (d < TRACE_HIT_THRESHOLD)
        {
            hit = true;
            hitPos = pos;
            if(bIsLedOn)
            {
                glowFactor = 1;
            }
            break;
        }
        pos += d * rd;
    }
    return hitPos;
}


// lighting
float3 shade(float3 pos, float3 n, float3 eyePos, float intensity)
{
    /*float3 smooth = smoothstep(0, LedCubeSide, pos);
    float3 difcolor = (smooth + 0.2) / 1.2;
  

    float ao = ambientOcclusion(pos, n, intensity);

    return difcolor * ao;*/

    float3 eyeDir =  eyePos - pos;
    float eyeDist = length(eyeDir);
    


    
    float3 difcolor = smoothstep(0, LedCubeSide, pos);
    float ao = ambientOcclusion(pos, n, intensity);
    
  /*  if(eyeDist > HalfLedCubeSide)
        return difcolor * ao;
    else*/
    {
        float limit = smoothstep(0, LedCubeSide, eyeDist);
    
        const float3 lightPos = 2*LedCubeSide;//float3(5.0, -4, -50.0);
        float3 lightdir = normalize(lightPos - pos);
        float3 halfdir = normalize(0.5*( lightdir+eyeDir));
    
        float4 lightingCoef = lit(dot(n,lightdir), dot(n,halfdir), 10) *ao ;
        lightingCoef.x = saturate(lightingCoef.x - limit);
        lightingCoef.y = saturate(lightingCoef.y + limit);
        lightingCoef.z = saturate(lightingCoef.z - limit);
   
        return lightingCoef.x * (float3)(0.01 )+ lightingCoef.y *difcolor *ao + lightingCoef.z * (float3)1.; 
    }
}




// transforms
float3 rotateX(float3 p, float a)
{
    float sa;
    float ca;
    sincos(a, sa, ca);
    float3 r;
    r.x = p.x;
    r.y = ca*p.y - sa*p.z;
    r.z = sa*p.y + ca*p.z;
    return r;
}

float3 rotateY(float3 p, float a)
{
    float sa;
    float ca;
    sincos(a, sa, ca);
    float3 r;
    r.x = ca*p.x + sa*p.z;
    r.y = p.y;
    r.z = -sa*p.x + ca*p.z;
    return r;
}

float4 rayMarcher(in CamAnimator cam, in IntensityProvider scene,  in LedDomain domain)
{
    float2x3 rays = cam.GetRays(); 

    //trace ray
    bool hit;
    int nbSteps;
    float glowFactor;
    float intensity;
    float3 pos = trace(scene, domain, rays[0], rays[1] , hit, nbSteps,glowFactor, intensity);


   

    float3 rgb = BACKGROUND_COLOR;

    if(hit)
    {
        // calc normal
        float3 n = sceneNormal(pos, intensity);
        rgb = shade(pos, n, rays[0], intensity);
        //rgb = (float3) float(nbSteps) / float(MAX_TRACE_STEPS-1);
        // Show normal like a normal map
        //rgb = 0.5 * n + (float3)0.5;  
    }

   return float4(rgb +  .75f*glowFactor, 1);
}



//http://glsl.heroku.com/e#4230.1
/*float4 main( PS_INPUT input) : SV_Target
{
    class Churchscene : IntensityProvider 
    { 
        float IntensityAt(float3 p) 
        { 
            return 1 - scene_old(p/1.5 + SequenceRatio*100*WorldAxis.X)*1.5;;
        }
    } churchScene;

    class Spherescene : IntensityProvider 
    { 
        float IntensityAt(float3 p) 
        { 
            return 1 - sdSphere(p - HalfLedCubeSide, 0.5*1.41* (1+ cos(10*SequenceRatio * 2 * Pi))* HalfLedCubeSide);
        }
    } sphereScene;

    class Cam : CamAnimator
    {
         float2x3 GetRays()
         {
                      // Pixel position
            float2 pixel = 2.0 * (input.Tex.xy  - float2( 0.5, 0.5 ) );
                // pixel.xy e [-1 1], same orientation
                //Let's move in view space, right handed (to fiz cross product errors

            float3 rayOrigin    = float3(HalfLedCubeSide,HalfLedCubeSide, 2*LedCubeSide);
            float3 rayDirection = normalize(float3(pixel.x * ScreenRatio, -pixel.y, -2));
    
            float t = SequenceRatio* 2 * Pi;
            //float a = -sin(t)*1.5;
            rayOrigin = HalfLedCubeSide+ rotateY(rayOrigin - HalfLedCubeSide , t);
            rayDirection =  rotateY(rayDirection, t);

            float2x3 array = {rayOrigin, rayDirection};

            return array;
         }
    } cam;
    


   
   return rayMarcher(cam, sphereScene);
}*/